/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AtmosphericConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestMountainsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestPlateauWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sparseRainforestPlateauWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestBasinWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sparseRainforestBasinWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> flourishingDunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rockyDunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rockyDunesHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> petrifiedDunesWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configurations for Atmospheric").push("common");
            builder.comment(new String[]{"Values for biome frequencies; lower = more rare. (Requires restart)", "If a biome has a default weight of 0, it generates as a sub-biome and not on its own."}).push("biome_weights");
            builder.comment("Rainforest biome weights").push("rainforest");
            this.rainforestWeight = builder.define("Rainforest weight", (Object)1);
            this.rainforestMountainsWeight = builder.define("Rainforest Mountains weight", (Object)1);
            this.rainforestPlateauWeight = builder.define("Rainforest Plateau weight", (Object)0);
            this.sparseRainforestPlateauWeight = builder.define("Sparse Rainforest Plateau weight", (Object)0);
            this.rainforestBasinWeight = builder.define("Rainforest Basin weight", (Object)1);
            this.sparseRainforestBasinWeight = builder.define("Sparse Rainforest Basin weight", (Object)0);
            builder.pop();
            builder.comment("Dunes biome weights").push("dunes");
            this.dunesWeight = builder.define("Dunes weight", (Object)5);
            this.dunesHillsWeight = builder.define("Dunes Hills weight", (Object)0);
            this.flourishingDunesWeight = builder.define("Flourishing Dunes weight", (Object)0);
            this.rockyDunesWeight = builder.define("Rocky Dunes weight", (Object)4);
            this.rockyDunesHillsWeight = builder.define("Rocky Dunes Hills weight", (Object)0);
            this.petrifiedDunesWeight = builder.define("Petrified Dunes weight", (Object)0);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

